   LOGICAL FUNCTION AJAR(OBJECT)
      USE ALLCOM
      INTEGER(4) OBJECT
      LOGICAL HINGED,VESSEL
      AJAR=BTEST(OBJCON(OBJECT),OPENBT).OR.(VESSEL(OBJECT).AND..NOT.HINGED(OBJECT))
      END

   LOGICAL FUNCTION AT(OBJECT)
      USE ALLCOM

!     TRUE IF ON EITHER SIDE OF TWO-PLACED OBJECT

      INTEGER OBJECT
       
      AT = .FALSE.
      IF (OBJECT.GE.1.AND.OBJECT.LE.MAXOBJ) AT=PLACE(OBJECT).EQ.LOC.OR.FIXED(OBJECT).EQ.LOC
      END

   LOGICAL FUNCTION BLIND()
      USE ALLCOM
      
!     TRUE IF DARKNESS OR GLARE
      
      LOGICAL DARK,ATHAND

      BLIND=DARK().OR.(LOC.EQ.200.AND.ATHAND(LAMP).AND.PROP(LAMP).EQ.1)
      END

   INTEGER FUNCTION CONFUZ()

!     GENERATES VARIANT OF "DON'T UNDERSTAND THAT" MESSAGE.

      LOGICAL PCT

      CONFUZ=60
      IF (PCT(50)) CONFUZ=61
      IF (PCT(33)) CONFUZ=13
      IF (PCT(25)) CONFUZ=347
      IF (PCT(20)) CONFUZ=195
      END

   LOGICAL FUNCTION DARK()
      USE ALLCOM
      LOGICAL ATHAND
      DARK=.FALSE.
      IF (LOC.GT.0) DARK=MOD(LOCCON(LOC),2).EQ.0.AND.(PROP(LAMP).EQ.0.OR..NOT.ATHAND(LAMP))
      END

   LOGICAL FUNCTION DEAD(OBJECT)
      USE ALLCOM
      INTEGER OBJECT
      DEAD=BTEST(OBJCON(OBJECT),DEADBT)
      END

   SUBROUTINE DESTROY(OBJECT)
      INTEGER OBJECT
      CALL MOVE(OBJECT,0)
      END

   LOGICAL FUNCTION EDIBLE(OBJECT)
      USE ALLCOM
      INTEGER OBJECT
      EDIBLE=BTEST(OBJCON(OBJECT),7)
      END

   LOGICAL FUNCTION ENCLSD(OBJECT)
      USE ALLCOM
      INTEGER OBJECT
      ENCLSD=.FALSE.
      IF (OBJECT.GE.1.AND.OBJECT.LE.MAXOBJ) ENCLSD=PLACE(OBJECT).LT.-1
      END

   LOGICAL FUNCTION FORCED(L)
      USE ALLCOM

!     A FORCED LOCATION IS ONE FROM WHICH ADVENTURER IS IMMEDIATELY BOUNCED TO ANOTHER.
!     NORMAL USE IS FOR DEATH (FORCE TO LOC ZERO) AND FOR DESCRIPTIONS OF JOURNEY FROM ONE PLACE TO ANOTHER.
      
      INTEGER L

      FORCED=.FALSE.
      IF (L.GT.0) FORCED=LOCCON(L).EQ.2
      END

   LOGICAL FUNCTION HERE(OBJECT)
      USE ALLCOM

!     TRUE IF THE OBJECT IS AT "LOC" OR IS BEING CARRIED

      INTEGER OBJECT
      LOGICAL TOTING
      HERE = .FALSE.
      IF (OBJECT.GT.1.AND.OBJECT.LE.MAXOBJ) HERE=PLACE(OBJECT).EQ.LOC .OR. TOTING(OBJECT)
      END

   LOGICAL FUNCTION HINGED(OBJECT)
      USE ALLCOM
      INTEGER OBJECT
      HINGED=BTEST(OBJCON(OBJECT),1)
      END

   LOGICAL FUNCTION HOLDNG(OBJECT)
      USE ALLCOM
      INTEGER OBJECT
      HOLDNG = .FALSE.
      IF (OBJECT.GE.1.OR.OBJECT.LE.MAXOBJ) HOLDNG=PLACE(OBJECT).EQ.-1
      END

   LOGICAL FUNCTION INSIDE(L)
      USE ALLCOM
      
!     TRUE IF LOCATION IS WELL WITHIN THE CAVE

      INTEGER L
      LOGICAL OUTSID
      INSIDE=.NOT.OUTSID(L).AND..NOT.BTEST(LOCCON(L),5)
      END

   SUBROUTINE JUGGLE(OBJECT)
      USE ALLCOM

!     JUGGLE AN OBJECT BY PICKING IT UP AND PUTTING IT DOWN AGAIN TO GET THE OBJECT TO THE FRONT OF THE CHAIN OF THINGS AT ITS LOC.
      
      INTEGER OBJECT,I,J

      I=PLACE(OBJECT)
      J=FIXED(OBJECT)
      CALL MOVE(OBJECT,I)
      CALL MOVE(OBJECT+MAXOBJ,J)
      END

   INTEGER FUNCTION LIQ(OBJECT)
      USE ALLCOM
      
      INTEGER OBJECT,IQ
      
      LIQ = 0
      IF (OBJECT.EQ.BOTTLE.OR.OBJECT.EQ.CASK) THEN
         IQ = MAX(PROP(OBJECT)+1,-1-(PROP(OBJECT)+1))
         IF (IQ.GT.0) LIQ=LIQTYP(IQ)
      ENDIF
      END

   INTEGER FUNCTION LIQ2(PBOTL)
      USE ALLCOM
      
      INTEGER PBOTL

      LIQ2=(1-PBOTL)*WATER+(PBOTL/2)*(WATER+OIL)+(PBOTL/4)*(WATER+WINE-2*OIL)
      END

   INTEGER FUNCTION LIQLOC()
      USE ALLCOM
      INTEGER LIQ2
      LIQLOC=LIQ2((MOD(LOCCON(LOC)/8,2)*(MOD(LOCCON(LOC)/2*2,16)-9)+1))
      END

   LOGICAL FUNCTION LIVING(OBJECT)
      USE ALLCOM
      INTEGER OBJECT
      LIVING=BTEST(OBJCON(OBJECT),9)
      END
  
   LOGICAL FUNCTION LOCKED(OBJECT)
      USE ALLCOM
      INTEGER OBJECT
      LOCKED=BTEST(OBJCON(OBJECT),4)
      END

   LOGICAL FUNCTION LOCKS(OBJECT)
      USE ALLCOM
      INTEGER OBJECT
      LOCKS=BTEST(OBJCON(OBJECT),3)
      END
       
   INTEGER FUNCTION NOWAY()

!     GENERATE'S SOME VARIANT OF "CAN'T DO THAT" MESSAGE.

      LOGICAL PCT

      NOWAY=14
      IF (PCT(50)) NOWAY=110
      IF (PCT(33)) NOWAY=147
      IF (PCT(25)) NOWAY=250
      IF (PCT(20)) NOWAY=262
      IF (PCT(17)) NOWAY=25
      IF (PCT(14)) NOWAY=345
      IF (PCT(12)) NOWAY=346
      END

   LOGICAL FUNCTION OPAQUE(OBJECT)
      USE ALLCOM
      INTEGER OBJECT
      OPAQUE=BTEST(OBJCON(OBJECT),6)
      END

   LOGICAL FUNCTION OUTSID(L)
      USE ALLCOM
      INTEGER L
      OUTSID=BTEST(LOCCON(L),6)
      END

   LOGICAL FUNCTION PCT(N)
      
      INTEGER RANZ,N
      
!     TRUE N% OF THE TIME (N INTEGER FROM 0 TO 100)

      PCT=RANZ(100).LT.N
      END

   LOGICAL FUNCTION PLURAL(OBJECT)
      USE ALLCOM

!     TRUE IF OBJECT IS A "BUNCH" OF THINGS (COINS, SHOES).

      INTEGER OBJECT
      PLURAL=.FALSE.
      IF (OBJECT.GT.0.AND.OBJECT.LE.MAX_OBJECT) PLURAL=BTEST(OBJCON(OBJECT),13)
      END

   LOGICAL FUNCTION PRINTD(OBJECT)
      USE ALLCOM
      INTEGER OBJECT
      PRINTD=BTEST(OBJCON(OBJECT),8)
      END

   INTEGER FUNCTION PUT(OBJECT,WHERE,PVAL)

!     SAME AS MOVE, EXCEPT RETURNS A VALUE USED TO SET UP THE NEGATED PROP VALUES FOR THE REPOSITORY OBJECTS.

      INTEGER OBJECT,WHERE,PVAL

      CALL MOVE(OBJECT,WHERE)
      PUT=(-1)-PVAL
      END

   INTEGER FUNCTION RANZ(RANGE)
      INTEGER(4) RANGE
      REAL(4) R
      CALL RANDOM_NUMBER(R)
      RANZ=R*RANGE
      END

   LOGICAL FUNCTION SMALL(OBJECT)
      USE ALLCOM
      INTEGER OBJECT
      SMALL=BTEST(OBJCON(OBJECT),5)
      END

   LOGICAL FUNCTION VESSEL(OBJECT)
      USE ALLCOM
      INTEGER OBJECT
      VESSEL=BTEST(OBJCON(OBJECT),15)
      END

   LOGICAL FUNCTION WEARNG(OBJECT)
      USE ALLCOM
      INTEGER OBJECT
      WEARNG=BTEST(OBJCON(OBJECT),WEARBT)
      END

   LOGICAL FUNCTION WEARABLE(OBJECT)
      USE ALLCOM
      INTEGER OBJECT
      WEARABLE=BTEST(OBJCON(OBJECT),11)
      END